<h2>Why is this an issue?</h2>
<p>A writable collection property can be replaced by a completely different collection. Making it <code>readonly</code> prevents that while still
allowing individual members to be set. If you want to allow the replacement of the whole collection the recommended pattern is to implement a method
to remove all the elements (e.g. <code>System.Collections.List&lt;T&gt;.Clear</code>) and a method to populate the collection (e.g.
<code>System.Collections.List&lt;T&gt;.AddRange</code>).</p>
<p>This rule raises an issue when an externally visible writable property is of a type that implements <code>System.Collections.ICollection</code> or
<code>System.Collections.Generic.ICollection&lt;T&gt;</code>.</p>
<h3>Noncompliant code example</h3>
<pre>
using System;
using System.Collections;

namespace MyLibrary
{
  public class Foo
  {
    List&lt;string&gt; strings;

    public List&lt;string&gt; SomeStrings
    {
      get { return strings; }
      set { strings = value; } // Noncompliant
    }
  }
}
</pre>
<h3>Compliant solution</h3>
<pre>
using System;
using System.Collections;

namespace MyLibrary
{
  public class Foo
  {
    List&lt;string&gt; strings;

    public List&lt;string&gt; SomeStrings
    {
      get { return strings; }
    }
  }
}
</pre>
<h3>Exceptions</h3>
<p>This rule does not raise issues for</p>
<ul>
  <li> <code>string</code>, <code>Array</code> and <code>PermissionSet,</code> </li>
  <li> properties marked as <code>DataMemberAttribute</code> </li>
  <li> classes marked as <code>Serializable</code> </li>
  <li> properties overriding a base class member </li>
  <li> properties implementing interface </li>
</ul>
<p>&nbsp;</p>

