<h2>Why is this an issue?</h2>
<p>If an <code>enum</code> member’s name contains the word "reserved" it implies it is not currently used and will be change in the future. However
changing an <code>enum</code> member is a breaking change and can create significant problems. There is no need to reserve an <code>enum</code> member
since a new member can be added in the future, and such an addition will usually not be a breaking change.</p>
<p>This rule raises an issue when the name of an enumeration member contains "reserved".</p>
<h3>Noncompliant code example</h3>
<pre>
using System;

namespace MyLibrary
{
  public enum Color
  {
        None,
        Red,
        Orange,
        Yellow,
        ReservedColor  // Noncompliant
    }
}
</pre>

