<h2>Why is this an issue?</h2>
<p>By default the storage type of an <code>enum</code> is <code>Int32</code>. In most cases it is not necessary to change this. In particular you will
not achieve any performance gain by using a smaller data type (e.g. <code>Byte</code>) and may limit future uses.</p>
<h3>Noncompliant code example</h3>
<pre>
using System;

namespace MyLibrary
{
    public enum Visibility : sbyte // Noncompliant
    {
        Visible = 0,
        Invisible = 1,
    }
}
</pre>
<h3>Compliant solution</h3>
<pre>
using System;

namespace MyLibrary
{
    public enum Visibility
    {
        Visible = 0,
        Invisible = 1,
    }
}
</pre>

