<h2>Why is this an issue?</h2>
<p>Many string operations, the <code>Compare</code> and <code>Equals</code> methods in particular, provide an overload that accepts a
<code>StringComparison</code> enumeration value as a parameter. Calling these overloads and explicitly providing this parameter makes your code
clearer and easier to maintain.</p>
<p>This rule raises an issue when a string comparison operation doesn’t use the overload that takes a <code>StringComparison</code> parameter.</p>
<h3>Noncompliant code example</h3>
<pre>
using System;

namespace MyLibrary
{
  public class Foo
  {
    public bool HaveSameNames(string name1, string name2)
    {
      return string.Compare(name1, name2) == 0; // Noncompliant
    }
  }
}
</pre>
<h3>Compliant solution</h3>
<pre>
using System;

namespace MyLibrary
{
  public class Foo
  {
    public bool HaveSameNames(string name1, string name2)
    {
      return string.Compare(name1, name2, StringComparison.OrdinalIgnoreCase) == 0;
    }
  }
}
</pre>

