<h2>Why is this an issue?</h2>
<p>When a collection is empty, iterating it has no effect. Doing so anyway is likely a bug; either population was accidentally omitted, or the
iteration needs to be revised.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
public void Method()
{
    var values = new List&lt;string&gt;();
    values.Remove("bar");              // Noncompliant
    if (values.Contains("foo")) { }    // Noncompliant
    foreach (var str in values) { }    // Noncompliant
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
public void Method()
{
    var values = LoadValues();
    values.Remove("bar");
    if (values.Contains("foo")) { }
    foreach (var str in values) { }
}
</pre>

