<p>Clear-text protocols such as <code>ftp</code>, <code>telnet</code>, or <code>http</code> lack encryption of transported data, as well as the
capability to build an authenticated connection. It means that an attacker able to sniff traffic from the network can read, modify, or corrupt the
transported content. These protocols are not secure as they expose applications to an extensive range of risks:</p>
<ul>
  <li> sensitive data exposure </li>
  <li> traffic redirected to a malicious endpoint </li>
  <li> malware-infected software update or installer </li>
  <li> execution of client-side code </li>
  <li> corruption of critical information </li>
</ul>
<p>Even in the context of isolated networks like offline environments or segmented cloud environments, the insider threat exists. Thus, attacks
involving communications being sniffed or tampered with can still happen.</p>
<p>For example, attackers could successfully compromise prior security layers by:</p>
<ul>
  <li> bypassing isolation mechanisms </li>
  <li> compromising a component of the network </li>
  <li> getting the credentials of an internal IAM account (either from a service account or an actual person) </li>
</ul>
<p>In such cases, encrypting communications would decrease the chances of attackers to successfully leak data or steal credentials from other network
components. By layering various security practices (segmentation and encryption, for example), the application will follow the
<em>defense-in-depth</em> principle.</p>
<p>Note that using the <code>http</code> protocol is being deprecated by <a
href="https://blog.mozilla.org/security/2015/04/30/deprecating-non-secure-http">major web browsers</a>.</p>
<p>In the past, it has led to the following vulnerabilities:</p>
<ul>
  <li> <a href="https://nvd.nist.gov/vuln/detail/CVE-2019-6169">CVE-2019-6169</a> </li>
  <li> <a href="https://nvd.nist.gov/vuln/detail/CVE-2019-12327">CVE-2019-12327</a> </li>
  <li> <a href="https://nvd.nist.gov/vuln/detail/CVE-2019-11065">CVE-2019-11065</a> </li>
</ul>
<h2>Ask Yourself Whether</h2>
<ul>
  <li> Application data needs to be protected against falsifications or leaks when transiting over the network. </li>
  <li> Application data transits over an untrusted network. </li>
  <li> Compliance rules require the service to encrypt data in transit. </li>
  <li> Your application renders web pages with a relaxed mixed content policy. </li>
  <li> OS-level protections against clear-text traffic are deactivated. </li>
</ul>
<p>There is a risk if you answered yes to any of those questions.</p>
<h2>Recommended Secure Coding Practices</h2>
<ul>
  <li> Make application data transit over a secure, authenticated and encrypted protocol like TLS or SSH. Here are a few alternatives to the most
  common clear-text protocols:
    <ul>
      <li> Use <code>ssh</code> as an alternative to <code>telnet</code>. </li>
      <li> Use <code>sftp</code>, <code>scp</code>, or <code>ftps</code> instead of <code>ftp</code>. </li>
      <li> Use <code>https</code> instead of <code>http</code>. </li>
      <li> Use <code>SMTP</code> over <code>SSL/TLS</code> or <code>SMTP</code> with <code>STARTTLS</code> instead of clear-text SMTP. </li>
    </ul>  </li>
  <li> Enable encryption of cloud components communications whenever it is possible. </li>
  <li> Configure your application to block mixed content when rendering web pages. </li>
  <li> If available, enforce OS-level deactivation of all clear-text traffic. </li>
</ul>
<p>It is recommended to secure all transport channels, even on local networks, as it can take a single non-secure connection to compromise an entire
application or system.</p>
<h2>Sensitive Code Example</h2>
<pre>
var urlHttp = "http://example.com";                 // Noncompliant
var urlFtp = "ftp://anonymous@example.com";         // Noncompliant
var urlTelnet = "telnet://anonymous@example.com";   // Noncompliant
</pre>
<pre>
using var smtp = new SmtpClient("host", 25); // Noncompliant, EnableSsl is not set
using var telnet = new MyTelnet.Client("host", port); // Noncompliant, rule raises Security Hotspot on any member containing "Telnet"
</pre>
<h2>Compliant Solution</h2>
<pre>
var urlHttps = "https://example.com";
var urlSftp = "sftp://anonymous@example.com";
var urlSsh = "ssh://anonymous@example.com";
</pre>
<pre>
using var smtp = new SmtpClient("host", 25) { EnableSsl = true };
using var ssh = new MySsh.Client("host", port);
</pre>
<h2>Exceptions</h2>
<p>No issue is reported for the following cases because they are not considered sensitive:</p>
<ul>
  <li> Insecure protocol scheme followed by loopback addresses like 127.0.0.1 or <code>localhost</code>. </li>
</ul>
<h2>See</h2>
<h3>Documentation</h3>
<ul>
  <li> AWS Documentation - <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html">Listeners for
  your Application Load Balancers</a> </li>
  <li> AWS Documentation - <a
  href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html">Stream Encryption</a>
  </li>
</ul>
<h3>Articles &amp; blog posts</h3>
<ul>
  <li> Google - <a href="https://security.googleblog.com/2016/09/moving-towards-more-secure-web.html">Moving towards more secure web</a> </li>
  <li> Mozilla - <a href="https://blog.mozilla.org/security/2015/04/30/deprecating-non-secure-http/">Deprecating non secure http</a> </li>
</ul>
<h3>Standards</h3>
<ul>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A3_2017-Sensitive_Data_Exposure">Top 10 2017 Category A3 - Sensitive Data
  Exposure</a> </li>
  <li> OWASP - <a href="https://owasp.org/Top10/A02_2021-Cryptographic_Failures/">Top 10 2021 Category A2 - Cryptographic Failures</a> </li>
  <li> OWASP - <a href="https://mas.owasp.org/checklists/MASVS-NETWORK/">Mobile AppSec Verification Standard - Network Communication Requirements</a>
  </li>
  <li> OWASP - <a href="https://owasp.org/www-project-mobile-top-10/2016-risks/m3-insecure-communication">Mobile Top 10 2016 Category M3 - Insecure
  Communication</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/200">CWE-200 - Exposure of Sensitive Information to an Unauthorized Actor</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/319">CWE-319 - Cleartext Transmission of Sensitive Information</a> </li>
  <li> STIG Viewer - <a href="https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222397">Application Security and
  Development: V-222397</a> - The application must implement cryptographic mechanisms to protect the integrity of remote access sessions. </li>
  <li> STIG Viewer - <a href="https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222534">Application Security and
  Development: V-222534</a> - Service-Oriented Applications handling non-releasable data must authenticate endpoint devices via mutual SSL/TLS. </li>
  <li> STIG Viewer - <a href="https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222562">Application Security and
  Development: V-222562</a> - Applications used for non-local maintenance must implement cryptographic mechanisms to protect the integrity of
  maintenance and diagnostic communications. </li>
  <li> STIG Viewer - <a href="https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222563">Application Security and
  Development: V-222563</a> - Applications used for non-local maintenance must implement cryptographic mechanisms to protect the confidentiality of
  maintenance and diagnostic communications. </li>
  <li> STIG Viewer - <a href="https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222577">Application Security and
  Development: V-222577</a> - The application must not expose session IDs. </li>
  <li> STIG Viewer - <a href="https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222596">Application Security and
  Development: V-222596</a> - The application must protect the confidentiality and integrity of transmitted information. </li>
  <li> STIG Viewer - <a href="https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222597">Application Security and
  Development: V-222597</a> - The application must implement cryptographic mechanisms to prevent unauthorized disclosure of information and/or detect
  changes to information during transmission. </li>
  <li> STIG Viewer - <a href="https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222598">Application Security and
  Development: V-222598</a> - The application must maintain the confidentiality and integrity of information during preparation for transmission.
  </li>
  <li> STIG Viewer - <a href="https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222599">Application Security and
  Development: V-222599</a> - The application must maintain the confidentiality and integrity of information during reception. </li>
</ul>

