﻿## SA1001

<table>
<tr>
  <td>TypeName</td>
  <td>SA1001CommasMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1001</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

The spacing around a comma is incorrect, within a C# code file.

## Rule description

A violation of this rule occurs when the spacing around a comma is incorrect.

A comma should be followed by a single space, except in the following cases.

* A comma may appear at the end of a line
* A comma should not be followed by a space when used in an open generic type in a `typeof` expression
* A comma is part of a string interpolation alignment component. For example:`$"{x,3}"`

A comma should never be preceded by a space or appear as the first token on a line.

## How to fix violations

To fix a violation of this rule, ensure that the comma is followed by a single space, and is not preceded by any space.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1001:CommasMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1001 // CommasMustBeSpacedCorrectly
#pragma warning restore SA1001 // CommasMustBeSpacedCorrectly
```
