﻿## SA1005

<table>
<tr>
  <td>TypeName</td>
  <td>SA1005SingleLineCommentsMustBeginWithSingleSpace</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1005</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

A single-line comment within a C# code file does not begin with a single space.

## Rule description

A violation of this rule occurs when a single-line comment does not begin with a single space. For example:

```csharp
private void Method1()
{
    //A single-line comment.
    //   A single-line comment.
}
```

The comments should begin with a single space after the leading forward slashes:

```csharp
private void Method1()
{
    // A single-line comment.
    // A single-line comment.
}
```

An exception to this rule occurs when the comment is being used to comment out a line of code. In this case, the space can be omitted if the comment begins with four forward slashes to indicate out-commented code. For example:

```csharp
private void Method1()
{
    ////int x = 2;
    ////return x;
}
```

## How to fix violations

To fix a violation of this rule, ensure that the comment begins with a single space. If the comment is being used to comment out a line of code, ensure that the comment begins with four forward slashes, in which case the leading space can be omitted.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1005:SingleLineCommentsMustBeginWithSingleSpace", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1005 // SingleLineCommentsMustBeginWithSingleSpace
#pragma warning restore SA1005 // SingleLineCommentsMustBeginWithSingleSpace
```
