﻿## SA1009

<table>
<tr>
  <td>TypeName</td>
  <td>SA1009ClosingParenthesisMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1009</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

A closing parenthesis within a C# statement is not spaced correctly.

## Rule description

A violation of this rule occurs when the closing parenthesis within a statement is not spaced correctly.

A closing parenthesis should never be preceded by whitespace. In most cases, a closing parenthesis should be followed by a single space, unless the closing parenthesis comes at the end of a cast, or the closing parenthesis is followed by certain types of operator symbols, such as positive signs, negative signs, and colons.

If the closing parenthesis is followed by whitespace, the next non-whitespace character should not be an opening or closing parenthesis or square bracket, or a semicolon or comma.

## How to fix violations

To fix a violation of this rule, ensure that the spacing around the closing parenthesis follows the rule described above.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1009:ClosingParenthesisMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1009 // ClosingParenthesisMustBeSpacedCorrectly
#pragma warning restore SA1009 // ClosingParenthesisMustBeSpacedCorrectly
```
