﻿## SA1012

<table>
<tr>
  <td>TypeName</td>
  <td>SA1012OpeningBracesMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1012</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

An opening brace within a C# element is not spaced correctly.

## Rule description

A violation of this rule occurs when the spacing around an opening brace is not correct.

An opening brace should always be preceded by a single space, unless it is the first character on the line, or unless it is preceded by an opening parenthesis, in which case there should be no space between the parenthesis and the brace.

An opening brace should always be followed by a single space, unless it is the last character on the line.

## How to fix violations

To fix a violation of this rule, ensure that the spacing around the opening brace follows the rule described above.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1012:OpeningBracesMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1012 // OpeningBracesMustBeSpacedCorrectly
#pragma warning restore SA1012 // OpeningBracesMustBeSpacedCorrectly
```
