﻿## SA1106

<table>
<tr>
  <td>TypeName</td>
  <td>SA1106CodeMustNotContainEmptyStatements</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1106</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

The C# code contains an extra semicolon.

## Rule description

A violation of this rule occurs when the code contain an extra semicolon. Syntactically, this results in an extra, empty statement in the code.

## How to fix violations

To fix a violation of this rule, remove the unneeded semicolon.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1106:CodeMustNotContainEmptyStatements", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1106 // CodeMustNotContainEmptyStatements
#pragma warning restore SA1106 // CodeMustNotContainEmptyStatements
```
