## SA1133

<table>
<tr>
  <td>TypeName</td>
  <td>SA1133DoNotCombineAttributes</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1133</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

Two or more attributes appeared within the same set of square brackets.

## Rule description

A violation of this rule occurs two or more attributes are placed within the same set of square brackets.

For example, the following code would produce a violation of this rule:

```csharp
[ExportCodeFixProvider(LanguageNames.CSharp, Name = nameof(MyCodeFixProvider)), Shared]
public class MyCodeFixProvider : CodeFixProvider
{
}
```

The following code would not produce any violations:

```csharp
[ExportCodeFixProvider(LanguageNames.CSharp, Name = nameof(MyCodeFixProvider))]
[Shared]
public class MyCodeFixProvider : CodeFixProvider
{
}
```

### Exceptions

A violation of this rule will not occur for attributes placed on parameters or type parameters.

For example, the following code will not produce violations:

```csharp
public class MyClass<[Foo, Bar] T>
{
	public T MyMethod([In, MarshalAs(UnmanagedType.LPWStr)] string value)
	{
	    ...
	}
}
```

## How to fix violations

To fix a violation of this rule, place each attribute within its own set of square brackets.

## How to suppress violations

```csharp
[ExportCodeFixProvider(LanguageNames.CSharp, Name = nameof(MyCodeFixProvider)),
#pragma warning disable SA1133 // Do not combine attributes
    Shared]
#pragma warning restore SA1133 // Do not combine attributes
public class MyCodeFixProvider : CodeFixProvider
{
}
```
