﻿## SA1209

<table>
<tr>
  <td>TypeName</td>
  <td>SA1209UsingAliasDirectivesMustBePlacedAfterOtherUsingDirectives</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1209</td>
</tr>
<tr>
  <td>Category</td>
  <td>Ordering Rules</td>
</tr>
</table>

## Cause

A using-alias directive is positioned before a regular using directive.

## Rule description

A violation of this rule occurs when a using-alias directive is placed before a normal using directive. Using-alias directives have special behavior which can alter the meaning of the rest of the code within the file or namespace. Placing the using-alias directives together below all other using-directives can make the code cleaner and easier to read, and can help make it easier to identify the types used throughout the code.

## How to fix violations

To fix an instance of this violation, place all using-alias directives beneath all normal using directives.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.OrderingRules", "SA1209:UsingAliasDirectivesMustBePlacedAfterOtherUsingDirectives", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1209 // UsingAliasDirectivesMustBePlacedAfterOtherUsingDirectives
#pragma warning restore SA1209 // UsingAliasDirectivesMustBePlacedAfterOtherUsingDirectives
```
