﻿## SA1211

<table>
<tr>
  <td>TypeName</td>
  <td>SA1211UsingAliasDirectivesMustBeOrderedAlphabeticallyByAliasName</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1211</td>
</tr>
<tr>
  <td>Category</td>
  <td>Ordering Rules</td>
</tr>
</table>

## Cause

The using-alias directives within a C# code file are not sorted alphabetically by alias name.

## Rule description

A violation of this rule occurs when the using-alias directives are not sorted alphabetically by alias name. Sorting the using-alias directives alphabetically can make the code cleaner and easier to read, and can help make it easier to identify the namespaces that are being used by the code.

## How to fix violations

To fix an instance of this violation, order the using-alias directives alphabetically by alias name.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.OrderingRules", "SA1211:UsingAliasDirectivesMustBeOrderedAlphabeticallyByAliasName", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1211 // UsingAliasDirectivesMustBeOrderedAlphabeticallyByAliasName
#pragma warning restore SA1211 // UsingAliasDirectivesMustBeOrderedAlphabeticallyByAliasName
```
