﻿# SA1412

<table>
<tr>
  <td>TypeName</td>
  <td>SA1412StoreFilesAsUtf8</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1412</td>
</tr>
<tr>
  <td>Category</td>
  <td>Maintainability Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

The encoding of the file is not UTF-8 with byte order mark.

## Rule description

Storing files in this encoding ensures that the files are always treated the same way by the compiler,
even when compiled on systems with varying default system encodings. In addition,
this encoding is the most widely supported encoding for features like visual diffs on GitHub and other tooling.
This encoding is also the default encoding used when creating new C# source files within Visual Studio.

## How to fix violations

To fix a violation of this rule, convert the files encoding to UTF-8 with byte order mark