﻿## SA1500

<table>
<tr>
  <td>TypeName</td>
  <td>SA1500BracesForMultiLineStatementsMustNotShareLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1500</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

## Cause

The opening or closing brace within a C# statement, element, or expression is not placed on its own line.

> :memo: The behavior of this rule can change based on the configuration of the `allowDoWhileOnClosingBrace` property in **stylecop.json**. See [Configuration.md](Configuration.md#Layout-Rules) for more information.

## Rule description

A violation of this rule occurs when the opening or closing brace within a statement, element, or expression is not placed on its own line. For example:

```csharp
public object Method()
{
    lock (this) {
        return this.value;
    }
}
```

When StyleCop checks this code, a violation of this rule will occur because the opening brace of the lock statement is placed on the same line as the lock keyword, rather than being placed on its own line, as follows:

```csharp
public object Method()
{
    lock (this) 
    {
        return this.value;
    }
}
```

A violation will also occur if the closing brace shares a line with other code. For example:

```csharp
public object Method()
{
    lock (this) 
    {
        return this.value; }
}
```

## How to fix violations

To fix a violation of this rule, ensure that both the opening and closing braces are placed on their own line, and do not share the line with any other code, other than comments.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.LayoutRules", "SA1500:BracesForMultiLineStatementsMustNotShareLine", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1500 // BracesForMultiLineStatementsMustNotShareLine
#pragma warning restore SA1500 // BracesForMultiLineStatementsMustNotShareLine
```
