﻿## SA1615

<table>
<tr>
  <td>TypeName</td>
  <td>SA1615ElementReturnValueMustBeDocumented</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1615</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

A C# element is missing documentation for its return value.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs if an element containing a return value is missing a `<returns>` tag.

## How to fix violations

To fix a violation of this rule, add and fill-in documentation text within a `<returns>` tag describing the value returned from the element.

The following example shows a method with a valid documentation header:

```csharp
/// <summary>
/// Joins a first name and a last name together into a single string.
/// </summary>
/// <param name="firstName">The first name to join.</param>
/// <param name="lastName">The last name to join.</param>
/// <returns>The joined names.</returns>
public string JoinNames(string firstName, string lastName)
{
    return firstName + " " + lastName;
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1615:ElementReturnValueMustBeDocumented", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1615 // ElementReturnValueMustBeDocumented
#pragma warning restore SA1615 // ElementReturnValueMustBeDocumented
```
