﻿## SA1618

<table>
<tr>
  <td>TypeName</td>
  <td>SA1618GenericTypeParametersMustBeDocumented</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1618</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

A generic C# element is missing documentation for one or more of its generic type parameters.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs if an element containing generic type parameters is missing documentation for one or more of its generic type parameters.

## How to fix violations

To fix a violation of this rule, add or fill-in documentation text within a <typeparam> tag for each generic type parameter on the element.

The following example shows a method with a valid documentation header:

```csharp
/// <summary>
/// A sample generic class.
/// </summary>
/// <typeparam name="S">The first generic type parameter.</typeparam>
/// <typeparam name="T">The second generic type parameter.</typeparam>
public class Class1<S, T>
{ 
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1618:GenericTypeParametersMustBeDocumented", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1618 // GenericTypeParametersMustBeDocumented
#pragma warning restore SA1618 // GenericTypeParametersMustBeDocumented
```
