﻿## SA1636

<table>
<tr>
  <td>TypeName</td>
  <td>SA1636FileHeaderCopyrightTextMustMatch</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1636</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The file header at the top of a C# code file does not contain the appropriate copyright text.

## Rule description

A violation of this rule occurs when the file header at the top of a C# file does not contain the copyright text that has been specified for the project.

In order to enable this rule, the `copyrightText` property must have been specified. See the [configuration](https://github.com/DotNetAnalyzers/StyleCopAnalyzers/blob/master/documentation/Configuration.md) section for details on how to set this up.

The value of the `xmlHeader` property will influence the behavior of this rule. When the `xmlHeader` property is **true** (the default), StyleCop Analyzers expects file headers to conform to the following standard StyleCop format.

```csharp
// <copyright file="{fileName}" company="{companyName}">
// {copyrightText}
// </copyright>
```

When the `xmlHeader` property is explicitly set to **false**, StyleCop Analyzers expects file headers to conform to the following customizable format.

```csharp
// {copyrightText}
```

With these settings in place, every file within the project should contain the required copyright text in the format described above.

### Comment styles
This rule will accept several comment styles. The examples below give an overview of accepted styles.

Examples with the `xmlHeader` property set to **true**
```csharp
// <copyright file="{fileName}" company="{companyName}">
// {copyrightText}
// </copyright>
```

```csharp
// ----------------------------------------------------------------------
// <copyright file="{fileName}" company="{companyName}">
// {copyrightText}
// </copyright>
// ----------------------------------------------------------------------
```

```csharp
/* <copyright file="{fileName}" company="{companyName}">
 * {copyrightText}
 * </copyright>
 */
```

```csharp
/*
  <copyright file="{fileName}" company="{companyName}">
  {copyrightText}
  </copyright>
*/
```

Examples with the `xmlHeader` property set to **false**

```csharp
// {copyrightText}
```

```csharp
/* {copyrightText} */
```

```csharp
/*
 * {copyrightText}
 */
```

```csharp
/*
  {copyrightText}
*/
```

## How to fix violations

To fix a violation of this rule, add your company's standard copyright text to the file header copyright tag.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1636:FileHeaderCopyrightTextMustMatch", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1636 // FileHeaderCopyrightTextMustMatch
#pragma warning restore SA1636 // FileHeaderCopyrightTextMustMatch
```
