﻿## SA1640

<table>
<tr>
  <td>TypeName</td>
  <td>SA1640FileHeaderMustHaveValidCompanyText</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1640</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The file header at the top of a C# code file does not contain company name text.

## Rule description

A violation of this rule occurs when the file header at the top of a C# file does not contain a company tag with company name text. For example:

```csharp
//-----------------------------------------------------------------------
// <copyright file="Widget.cs" company="">
//     Custom company copyright tag.
// </copyright>
//-----------------------------------------------------------------------
```

The company attribute should have text in it. For example:

```csharp
//-----------------------------------------------------------------------
// <copyright file="Widget.cs" company="My Company">
//     Custom company copyright tag.
// </copyright>
//-----------------------------------------------------------------------
```

## How to fix violations

To fix a violation of this rule, add and fill-in a company attribute containing the name of the company.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1640:FileHeaderMustHaveValidCompanyText", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1640 // FileHeaderMustHaveValidCompanyText
#pragma warning restore SA1640 // FileHeaderMustHaveValidCompanyText
```
