﻿## SA1641

<table>
<tr>
  <td>TypeName</td>
  <td>SA1641FileHeaderCompanyNameTextMustMatch</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1641</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The file header at the top of a C# code file does not contain the appropriate company name text.

## Rule description

A violation of this rule occurs when the file header at the top of a C# file does not contain the company name text that has been specified for the project.

In order to enable this rule, the `companyName` property must have been specified. In addition to that, the `xmlHeader` property must be either omitted or have a value of **true**.
See the [configuration](https://github.com/DotNetAnalyzers/StyleCopAnalyzers/blob/master/documentation/Configuration.md) section for details on how to set this up.

With these settings in place, every file within the project should contain the required company name text within its file header copyright tag, as shown in the example below:

```csharp
//-----------------------------------------------------------------------
// <copyright file="Widget.cs" company="My Company">
//     Custom company copyright tag.
// </copyright>
//-----------------------------------------------------------------------
```

## How to fix violations

To fix a violation of this rule, add your company's standard company name text to the file header copyright tag.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1641:FileHeaderCompanyNameTextMustMatch", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1641 // FileHeaderCompanyNameTextMustMatch
#pragma warning restore SA1641 // FileHeaderCompanyNameTextMustMatch
```
