﻿## SA1650

<table>
<tr>
  <td>TypeName</td>
  <td>SA1650ElementDocumentationMustBeSpelledCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1650</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

:warning: This rule has been intentionally omitted from StyleCop Analyzers. See [KnownChanges.md](KnownChanges.md) for
additional information.

## Cause

The element documentation for the element contains one or more spelling mistakes or unrecognized words.

## Rule description

A violation of this rule occurs when the element documentation contains spelling mistakes:

```csharp
/// <summary>
/// Joinsnames
/// </summary>
/// <param name="firstName">The first name.</param>
/// <param name="lastName">The last name.</param>
/// <returns>Name</returns>
public string JoinNames(string firstName, string lastName)
{
    ...
}
```

The spelling is checked using the culture specified in the Settings.StyleCop file (and en-US by default).

In this example the word Joinsnames in the summary element is misspelled. Either correct the spelling, insert any C# names in `<c> </c>` elements, suppress the violation or add the Joinsnames to a CustomDictionary.xml file.

CustomDictionary.xml files can contain words that the spelling checker does not normally recognise.

The CustomDictionary.xml file should be placed in the same folder as the StyleCop.dll and the Rules. That folder (and all subfolders) are checked for the dictionary files.

StyleCop loads CustomDictionary.xml, CustomDictionary.en-GB.xml and then CustomDictionary.en.xml (where en-GB is the culture specified in the Settings.StyleCop file).

StyleCop also loads custom.dic, custom.en-GB.dic and then custom.en.dic (where en-GB is the culture specified in the Settings.StyleCop file).

Recognized words can also be added to the Settings.StyleCop file using the Settings Editor on the spelling tab.

Attribute values in the documentation xml of the element are not checked for spelling.

Any text inside `<c> </c>` or `<code> </code>` elements is also ignored.

Any text starting with and ending with '$' or starting and ending with '$$' is also ignored. i.e. $$(thtp kthpo kthpk)$$.

## How to fix violations

To fix a violation of this rule, correct any spelling mistakes in the element documentation.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1650:ElementDocumentationMustBeSpelledCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1650 // ElementDocumentationMustBeSpelledCorrectly
#pragma warning restore SA1650 // ElementDocumentationMustBeSpelledCorrectly
```
