<h2>Why is this an issue?</h2>
<p>Return of boolean literal statements wrapped into <code>if-then-else</code> ones should be simplified.</p>
<p>Similarly, method invocations wrapped into <code>if-then-else</code> differing only from boolean literals should be simplified into a single
invocation.</p>
<h3>Noncompliant code example</h3>

```java
boolean foo(Object param) {
  if (expression) { // Noncompliant
    bar(param, true, "qix");
  } else {
    bar(param, false, "qix");
  }

  if (expression) {  // Noncompliant
    return true;
  } else {
    return false;
  }
}
```
<h3>Compliant solution</h3>

```java
boolean foo(Object param) {
  bar(param, expression, "qix");

  return expression;
}
```