<h2>Why is this an issue?</h2>
<p>Calling <code>System.exit(int status)</code> or <code>Rutime.getRuntime().exit(int status)</code> calls the shutdown hooks and shuts downs the
entire Java virtual machine. Calling <code>Runtime.getRuntime().halt(int)</code> does an immediate shutdown, without calling the shutdown hooks, and
skipping finalization.</p>
<p>Each of these methods should be used with extreme care, and only when the intent is to stop the whole Java process. For instance, none of them
should be called from applications running in a J2EE container.</p>
<h3>Noncompliant code example</h3>

```java
System.exit(0);
Runtime.getRuntime().exit(0);
Runtime.getRuntime().halt(0);
```
<h3>Exceptions</h3>
<p>These methods are ignored inside <code>main</code>.</p>
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/382">CWE-382 - Use of System.exit()</a> </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/7zZGBQ">CERT, ERR09-J.</a> - Do not allow untrusted code to terminate the JVM </li>
</ul>