<h2>Why is this an issue?</h2>
<p>If an exception is already being thrown within the <code>try</code> block or caught in a <code>catch</code> block, throwing another exception in
the <code>finally</code> block will override the original exception. This means that the original exception’s message and stack trace will be lost,
potentially making it challenging to diagnose and troubleshoot the root cause of the problem.</p>

```java
try {
  /* some work which end up throwing an exception */
  throw new IllegalArgumentException();
} finally {
  /* clean up */
  throw new RuntimeException();       // Noncompliant; masks the IllegalArgumentException
}
```

```java
try {
  /* some work which end up throwing an exception */
  throw new IllegalArgumentException();
} finally {
  /* clean up */
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/FTZGBQ">CERT, ERR05-J.</a> - Do not let checked exceptions escape from a finally block </li>
</ul>