<h2>Why is this an issue?</h2>
<p>According to the Java <code>Comparable.compareTo(T o)</code> documentation:</p>
<blockquote>
  <p>It is strongly recommended, but not strictly required that <code>(x.compareTo(y)==0) == (x.equals(y))</code>.</p>
  <p>Generally speaking, any class that implements the Comparable interface and violates this condition should clearly indicate this fact.</p>
  <p>The recommended language is "Note: this class has a natural ordering that is inconsistent with equals."</p>
</blockquote>
<p>If this rule is violated, weird and unpredictable failures can occur.</p>
<p>For example, in Java 5 the <code>PriorityQueue.remove()</code> method relied on <code>compareTo()</code>, but since Java 6 it has relied on
<code>equals()</code>.</p>
<h3>Noncompliant code example</h3>

```java
public class Foo implements Comparable<Foo> {
  @Override
  public int compareTo(Foo foo) { /* ... */ }      // Noncompliant as the equals(Object obj) method is not overridden
}
```
<h3>Compliant solution</h3>

```java
public class Foo implements Comparable<Foo> {
  @Override
  public int compareTo(Foo foo) { /* ... */ }      // Compliant

  @Override
  public boolean equals(Object obj) { /* ... */ }
}
```