<p>This rule raises an issue when a lambda expression uses block notation while expression notation could be used.</p>
<h2>Why is this an issue?</h2>
<p>The right-hand side of a lambda expression can be written in two ways:</p>
<ol>
  <li> Expression notation: the right-hand side is as an expression, such as in <code>(a, b) → a + b</code> </li>
  <li> Block notation: the right-hand side is a conventional function body with a code block and an optional return statement, such as in <code>(a, b)
  → {return a + b;}</code> </li>
</ol>
<p>By convention, expression notation is preferred over block notation. Block notation must be used when the function implementation requires more
than one statement. However, when the code block consists of only one statement (which may or may not be a <code>return</code> statement), it can be
rewritten using expression notation.</p>
<p>This convention exists because expression notation has a cleaner, more concise, functional programming style and is regarded as more readable.</p>
<h2>How to fix it</h2>
<ul>
  <li> If the code block consists only of a <code>return</code> statement, replace the code block with the argument expression from the
  <code>return</code> statement. </li>
  <li> If the code block consists of a single statement that is not a <code>return</code> statement, replace the code block with that statement. </li>
</ul>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
(a, b) -> { return a + b; } // Noncompliant, replace code block with expression
```
<h4>Compliant solution</h4>

```java
(a, b) -> a + b             // Compliant
```
<h4>Noncompliant code example</h4>

```java
x -> {System.out.println(x+1);} // Noncompliant, replace code block with statement
```
<h4>Compliant solution</h4>

```java
x -> System.out.println(x+1)    // Compliant
```