<h2>Why is this an issue?</h2>
<p>The default implementation of <code>java.lang.Thread</code> 's <code>run</code> will only perform a task passed as a <code>Runnable</code>. If no
<code>Runnable</code> has been provided at construction time, then the thread will not perform any action.</p>
<p>When extending <code>java.lang.Thread</code>, you should override the <code>run</code> method or pass a <code>Runnable</code> target to the
constructor of <code>java.lang.Thread</code>.</p>
<h3>Noncompliant code example</h3>

```java
public class MyThread extends Thread { // Noncompliant
  public void doSomething() {
    System.out.println("Hello, World!");
  }
}
```
<h2>How to fix it</h2>
<p>To fix this issue, you have 2 options:</p>
<ul>
  <li> override the <code>run</code> method </li>
</ul>

```java
public class MyThread extends Thread {
  @Override
  public void run() {
    System.out.println("Hello, World!");
  }
}
```
<ul>
  <li> provide a <code>Runnable</code> at construction time </li>
</ul>

```java
public class MyRunnable implements Runnable {
  @Override
  public void run() {
    System.out.println("Hello, World!");
  }
}
public class MyThread extends Thread {
  public MyThread(Runnable runnable) {
    super(runnable);
  }
}

public class Main() {
  public static void main(String [] args) {
    Runnable runnable = new MyRunnable();
    Thread customThread = new MyThread(runnable);
    Thread regularThread = new Thread(runnable);
  }
}
```