<h2>Why is this an issue?</h2>
<p>When the names of parameters in a method call match the names of the method arguments, it contributes to clearer, more readable code. However, when
the names match, but are passed in a different order than the method arguments, it indicates a mistake in the parameter order which will likely lead
to unexpected results.</p>
<h3>Noncompliant code example</h3>

```java
public double divide(int divisor, int dividend) {
  return divisor/dividend;
}

public void doTheThing() {
  int divisor = 15;
  int dividend = 5;

  double result = divide(dividend, divisor);  // Noncompliant; operation succeeds, but result is unexpected
  //...
}
```
<h3>Compliant solution</h3>

```java
public double divide(int divisor, int dividend) {
  return divisor/dividend;
}

public void doTheThing() {
  int divisor = 15;
  int dividend = 5;

  double result = divide(divisor, dividend);
  //...
}
```