<h2>Why is this an issue?</h2>
<p>Non-overridable methods (<code>private</code> or <code>final</code>) that don’t access instance data can be <code>static</code> to prevent any
misunderstanding about the contract of the method.</p>
<h3>Noncompliant code example</h3>

```java
class Utilities {
  private static String magicWord = "magic";

  private String getMagicWord() { // Noncompliant
    return magicWord;
  }

  private void setMagicWord(String value) { // Noncompliant
    magicWord = value;
  }

}
```
<h3>Compliant solution</h3>

```java
class Utilities {
  private static String magicWord = "magic";

  private static String getMagicWord() {
    return magicWord;
  }

  private static void setMagicWord(String value) {
    magicWord = value;
  }

}
```
<h3>Exceptions</h3>
<p>When <code>java.io.Serializable</code> is implemented the following three methods are excluded by the rule:</p>
<ul>
  <li> <code>private void writeObject(java.io.ObjectOutputStream out) throws IOException;</code> </li>
  <li> <code>private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException;</code> </li>
  <li> <code>private void readObjectNoData() throws ObjectStreamException;</code> </li>
</ul>