<h2>Why is this an issue?</h2>
<p>The semantics of <code>Thread</code> and <code>Runnable</code> are different, and while it is technically correct to use <code>Thread</code> where
a <code>Runnable</code> is expected, it is a bad practice to do so.</p>
<p>The crux of the issue is that <code>Thread</code> is a larger concept than <code>Runnable</code>. A <code>Runnable</code> represents a task. A
<code>Thread</code> represents a task and its execution management (ie: how it should behave when started, stopped, resumed, …​). It is both a task
and a lifecycle management.</p>
<h3>Noncompliant code example</h3>

```java
public static void main(String[] args) {
	Thread runnable = new Thread() {
		@Override
		public void run() { /* ... */ }
	};
	new Thread(runnable).start();  // Noncompliant
}
```
<h3>Compliant solution</h3>

```java
public static void main(String[] args) {
	Runnable runnable = new Runnable() {
		@Override
		public void run() { /* ... */ }
	};
	new Thread(runnable).start();
}
```