<h2>Why is this an issue?</h2>
<p>This rule involves the use of <code>Math.abs</code> and negation on numbers that could be <code>MIN_VALUE</code>. It is a problem because it can
lead to incorrect results and unexpected behavior in the program.</p>
<p>When <code>Math.abs</code> and negation are used on numbers that could be <code>MIN_VALUE</code>, the result can be incorrect due to integer
overflow. Common methods that can return a <code>MIN_VALUE</code> and raise an issue when used together with <code>Math.abs</code> are:</p>
<ul>
  <li> <code>Random.nextInt()</code> and <code>Random.nextLong()</code> </li>
  <li> <code>hashCode()</code> </li>
  <li> <code>compareTo()</code> </li>
</ul>
<p>Alternatively, the <code>absExact()</code> method throws an <code>ArithmeticException</code> for <code>MIN_VALUE</code>.</p>
<h3>Noncompliant code example</h3>

```java
public void doSomething(String str) {
  if (Math.abs(str.hashCode()) > 0) { // Noncompliant
    // ...
  }
}
```
<h3>Compliant solution</h3>

```java
public void doSomething(String str) {
  if (str.hashCode() != 0) {
    // ...
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.oracle.com/en/java/javase/20/docs/api/java.base/java/lang/Math.html#abs(int)">Oracle SDK 20 - Math.abs(int)</a> </li>
</ul>