<h2>Why is this an issue?</h2>
<p><code>Optional</code> value can hold either a value or not. The value held in the <code>Optional</code> can be accessed using the
<code>get()</code> method, but it will throw a</p>
<p><code>NoSuchElementException</code> if there is no value present. To avoid the exception, calling the <code>isPresent()</code> or <code>!
isEmpty()</code> method should always be done before any call to <code>get()</code>.</p>
<p>Alternatively, note that other methods such as <code>orElse(...)</code>, <code>orElseGet(...)</code> or <code>orElseThrow(...)</code> can be used
to specify what to do with an empty <code>Optional</code>.</p>
<h3>Noncompliant code example</h3>

```java
Optional<String> value = this.getOptionalValue();

// ...

String stringValue = value.get(); // Noncompliant
```

```java
if (methodThatReturnsOptional().isEmpty()) {
  throw new NotFoundException();
}
String value = methodThatReturnsOptional().get(); // Noncompliant: indirect access, we consider that two consecutive calls can return different values.
```
<h3>Compliant solution</h3>

```java
this.getOptionalValue().ifPresent(stringValue ->
  // Do something with stringValue
);
```
<p>or</p>

```java
Optional<String> value = this.getOptionalValue();

// ...

if (value.isPresent()) {
  String stringValue = value.get();
}
```
<p>or</p>

```java
Optional<String> value = this.getOptionalValue();

// ...

String stringValue = value.orElse("default");
```

```java
Optional<String> optional = methodThatReturnsOptional();
if (optional.isEmpty()) {
  throw new NotFoundException();
}
String value = optional.get();
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/476">CWE-476 - NULL Pointer Dereference</a> </li>
</ul>