<h2>Why is this an issue?</h2>
<p>Having all branches of a <code>switch</code> or <code>if</code> chain with the same implementation indicates a problem.</p>
<p>In the following code:</p>

```java
if (b == 0) {  // Noncompliant
  doOneMoreThing();
} else {
  doOneMoreThing();
}

int b = a > 12 ? 4 : 4;  // Noncompliant

switch (i) {  // Noncompliant
  case 1:
    doSomething();
    break;
  case 2:
    doSomething();
    break;
  case 3:
    doSomething();
    break;
  default:
    doSomething();
}
```
<p>Either there is a copy-paste error that needs fixing or an unnecessary <code>switch</code> or <code>if</code> chain that should be removed.</p>
<h3>Exceptions</h3>
<p>This rule does not apply to <code>if</code> chains without <code>else</code>, nor to <code>switch</code> without a <code>default</code> clause.</p>

```java
if(b == 0) {    //no issue, this could have been done on purpose to make the code more readable
  doSomething();
} else if(b == 1) {
  doSomething();
}
```