<h2>Why is this an issue?</h2>
<p>There’s no need to null test in conjunction with an <code>instanceof</code> test. <code>null</code> is not an <code>instanceof</code> anything, so
a null check is redundant.</p>
<h3>Noncompliant code example</h3>

```java
if (x != null && x instanceof MyClass) { ... }  // Noncompliant

if (x == null || ! x instanceof MyClass) { ... } // Noncompliant
```
<h3>Compliant solution</h3>

```java
if (x instanceof MyClass) { ... }

if (! x instanceof MyClass) { ... }
```