<h2>Why is this an issue?</h2>
<p>It’s almost always a mistake to compare two instances of <code>java.lang.String</code> or boxed types like <code>java.lang.Integer</code> using
reference equality <code>==</code> or <code>!=</code>, because it is not comparing actual value but locations in memory.</p>
<h3>Noncompliant code example</h3>

```java
String firstName = getFirstName(); // String overrides equals
String lastName = getLastName();

if (firstName == lastName) { ... }; // Non-compliant; false even if the strings have the same value
```
<h3>Compliant solution</h3>

```java
String firstName = getFirstName();
String lastName = getLastName();

if (firstName != null && firstName.equals(lastName)) { ... };
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/595">CWE-595 - Comparison of Object References Instead of Object Contents</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/597">CWE-597 - Use of Wrong Operator in String Comparison</a> </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/UjdGBQ">CERT, EXP03-J.</a> - Do not use the equality operators when comparing values of boxed
  primitives </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/yDdGBQ">CERT, EXP50-J.</a> - Do not confuse abstract object equality with reference equality
  </li>
</ul>