<h2>Why is this an issue?</h2>
<p>The private class members were introduced in ES2022 and use <code>#</code> (hash) symbol prefix. It is possible to declare private fields, methods,
getters and setters as well as their static counterparts. The private members are only accessible from within the current class body and aren’t
inherited by subclasses. They also cannot be removed with <code>delete</code> operator.</p>

```js
class MyClass {
    #foo = 123;
    bar(){
        return this.#foo; // ok
    }
}

const obj = new MyClass();
obj.#foo = 345; // error: #foo is not accessible outside of the class
```
<p>Private class members that are declared and not used anywhere in the code are most likely an error due to incomplete refactoring and should be
corrected or removed.</p>

```js
class MyClass {
    #privateField1;
    #privateField2;  // Noncompliant: #privateField2 is unused
    #privateMethod(){} // Noncompliant: #privateMethod is unused
    publicMethod(){
        return this.#privateField1;
    }
}
```
<p>To fix the code remove unused private member of the class.</p>

```js
class MyClass {
    #privateField1;
    publicMethod(){
        return this.#privateField1;
    }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes/Private_class_fields">Private class
  features</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes">Classes</a> </li>
</ul>