<h2>Why is this an issue?</h2>
<p>The <code>if...else</code> statement is used to make decisions based on the truthiness of a boolean expression, and the <code>if</code> block
executes when the expression is truthy, while the <code>else</code> block executes when the expression is falsy.</p>
<p>Wrapping a boolean expression in an <code>if...else</code> statement and returning <code>true</code> or <code>false</code> in the respective blocks
is redundant and unnecessary. It can also make the code harder to maintain, as it adds unnecessary lines of code that need to be read and
understood.</p>

```js
if (expression) {
  return true;
} else {
  return false;
}
```
<p>Simplify the code and return the boolean expression (or its negation) directly to make the code more concise and easier to read and maintain.</p>

```js
return expression;
```
<p>If the caller expects a boolean and the result of the expression is not a boolean, use double negation for proper conversion.</p>

```js
return !!expression;
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean">Boolean</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/if...else"><code>if...else</code></a>
  </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Logical_NOT#double_not_!!">Double NOT
  (<code>!!</code>)</a> </li>
</ul>