<p>Variables, properties, and parameters should be named consistently to communicate intent and improve maintainability. Rename your variable,
property, or parameter to follow your project’s naming convention to address this issue.</p>
<h2>Why is this an issue?</h2>
<p>A naming convention in software development is a set of guidelines for naming code elements like variables, functions, and classes.<br> Variables,
properties, and parameters hold the meaning of the written code. Their names should be meaningful and follow a consistent and easily recognizable
pattern.<br> Adhering to a consistent naming convention helps to make the code more readable and understandable, which makes it easier to maintain and
debug. It also ensures consistency in the code, especially when multiple developers are working on the same project.</p>
<p>This rule checks that variable, property, and parameter names match a provided regular expression.</p>
<h3>What is the potential impact?</h3>
<p>Inconsistent naming of variables, properties, and parameters can lead to several issues in your code:</p>
<ul>
  <li> <strong>Reduced Readability</strong>: Inconsistent variable, property, and parameter names make the code harder to read and understand;
  consequently, it is more difficult to identify the purpose of each variable, spot errors, or comprehend the logic. </li>
  <li> <strong>Difficulty in Identifying Variables</strong>: The variables, properties, and parameters that don’t adhere to a standard naming
  convention are challenging to identify; thus, the coding process slows down, especially when dealing with a large codebase. </li>
  <li> <strong>Increased Risk of Errors</strong>: Inconsistent or unclear variable, property, and parameter names lead to misunderstandings about what
  the variable represents. This ambiguity leads to incorrect assumptions and, consequently, bugs in the code. </li>
  <li> <strong>Collaboration Difficulties</strong>: In a team setting, inconsistent naming conventions lead to confusion and miscommunication among
  team members. </li>
  <li> <strong>Difficulty in Code Maintenance</strong>: Inconsistent naming leads to an inconsistent codebase. The code is difficult to understand,
  and making changes feels like refactoring constantly, as you face different naming methods. Ultimately, it makes the codebase harder to maintain.
  </li>
</ul>
<p>In summary, not adhering to a naming convention for variables, properties, and parameters can lead to confusion, errors, and inefficiencies, making
the code harder to read, understand, and maintain.</p>
<h2>How to fix it</h2>
<p>First, familiarize yourself with the particular naming convention of the project in question. Then, update the name to match the convention, as
well as all usages of the name. For many IDEs, you can use built-in renaming and refactoring features to update all usages at once.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<p>With the default regular expression <code>^[_$A-Za-z][$A-Za-z0-9]*$|^[_$A-Z][_$A-Z0-9]+$</code>:</p>

```js
const foo_bar = 1; // Noncompliant
const baz_ = 2; // Noncompliant
```
<h4>Compliant solution</h4>

```js
const fooBar = 1;
const _baz = 2;
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/MDN/Writing_guidelines/Writing_style_guide/Code_style_guide/JavaScript#variable_names">Guidelines for
  writing JavaScript code: Variable names</a> </li>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/Naming_convention_(programming)">Naming Convention (programming)</a> </li>
</ul>
<h3>Related rules</h3>
<ul>
  <li> <a href='checks/checks/?languages=JAVASCRIPT&tools=SONAR_LINT&rule=javascript:S100'>javascript:S100</a> - Function and method names should comply with a naming convention </li>
  <li> <a href='checks/checks/?languages=JAVASCRIPT&tools=SONAR_LINT&rule=javascript:S101'>javascript:S101</a> - Class names should comply with a naming convention </li>
</ul>