<p>Control structures are code statements that impact the program’s control flow (e.g., if statements, for loops, etc.)</p>
<h2>Why is this an issue?</h2>
<p>While not technically incorrect, the omission of curly braces can be misleading and may lead to the introduction of errors during maintenance.</p>
<p>In the following example, the two calls seem to be attached to the <code>if</code> statement, but only the first one is, and
<code>checkSomething</code> will always be executed:</p>

```js
if (condition)  // Noncompliant
  executeSomething();
  checkSomething();
```
<p>Adding curly braces improves the code readability and its robustness:</p>

```js
if (condition) {
  executeSomething();
  checkSomething();
}
```
<p>The rule raises an issue when a control structure has no curly braces.</p>