<h2>Why is this an issue?</h2>
<p>Variables declared with <code>var</code> have the special property that regardless of where they’re declared in a function they "float" to the top
of the function and are available for use even before they’re declared. That makes scoping confusing, especially for new coders.</p>
<p>To keep confusion to a minimum, <code>var</code> declarations should happen before they are used for the first time.</p>
<h3>Noncompliant code example</h3>

```js
var x = 1;

function fun(){
  alert(x); // Noncompliant as x is declared later in the same scope
  if(something) {
    var x = 42; // Declaration in function scope (not block scope!) shadows global variable
  }
}

fun(); // Unexpectedly alerts "undefined" instead of "1"
```
<h3>Compliant solution</h3>

```js
var x = 1;

function fun() {
  print(x);
  if (something) {
    x = 42;
  }
}

fun(); // Print "1"
```