<h2>Why is this an issue?</h2>
<p>A value that is incremented or decremented and then not stored is at best wasted code and at worst a bug.</p>
<h3>Noncompliant code example</h3>

```js
function pickNumber() {
  let i = 0;
  i = i++; // Noncompliant; i is still zero

  return i++; // Noncompliant; 0 returned
}
```
<h3>Compliant solution</h3>

```js
function pickNumber() {
  let i = 0;
  i++;

  return ++i;
}
```