<h2>Why is this an issue?</h2>
<p>Loop counters, such as variables used to track the iteration count in loops, should not be assigned from within the loop body to avoid unexpected
behavior and bugs. It can inadvertently lead to an infinite loop or make the loop behavior more complex and harder to reason about.</p>

```js
const names = [ "Jack", "Jim", "", "John" ];
for (let i = 0; i < names.length; i++) {
  if (!names[i]) {
    i = names.length; // Noncompliant: The loop counter i is assigned within the loop body
  } else {
    console.log(names[i]);
  }
}
```
<p>To avoid these issues, you should update the loop counter only in the loop’s update statement, typically located at the end of the loop body or
within the loop header.</p>

```js
const names = [ "Jack", "Jim", "", "John" ];
for (let i = 0; i < names.length; i++) {
  if (!names[i]) {
    break;
  } else {
    console.log(names[i]);
  }
}
```
<p>Alternatively, you should use the <code>for…​of</code> statement if your intention is only to iterate over the values of an iterable object.</p>

```js
const names = [ "Jack", "Jim", "", "John" ];
for (const name of names) {
  if (!name) {
    break;
  } else {
    console.log(name);
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/for">for</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/for...of"><code>for...of</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols">Iteration protocols</a> </li>
</ul>