<h2>Why is this an issue?</h2>
<p>The <code>delete</code> operator is used to remove a property from an object. It only affects its <a
href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/hasOwn">own</a> properties. There are two valid ways to
remove a property:</p>
<ul>
  <li> Using the dot notation: <code>delete object.property</code> </li>
  <li> Using the bracket notation: <code>delete object[property]</code> </li>
</ul>
<p><code>delete</code> will throw a <code>TypeError</code> in strict mode if the property is a non-configurable property.</p>
<p><code>delete identifier</code> may work if <code>identifier</code> is a <strong>configurable</strong> property of the global object. For
<code>identifier</code> to be <strong>configurable</strong>, it should have been declared directly as a <code>globalThis</code> property
(<code>globalThis.identifier = 1</code>). This form is not common practice and should be avoided. Use <code>delete globalThis.identifier</code>
instead if needed.</p>
<p>Aside from that case, deleting variables, including function parameters, never works:</p>
<ul>
  <li> Variables declared with <code>var</code> cannot be deleted from the global or a function’s scope, because while they may be attached to the
  global object, they are <strong>non-configurable</strong>. In CommonJS and ECMAScript modules, top-level variable declarations are scoped to the
  module and not attached to the global object. </li>
  <li> Variables declared with <code>let</code> or <code>const</code> are not attached to any object. </li>
</ul>

```js
var x = 1;
delete x; // Noncompliant: depending on the context, this does nothing or throws TypeError

function foo(){}
delete foo; // Noncompliant: depending on the context, this does nothing or throws TypeError
```
<p>Avoid using the <code>delete identifier</code> form. Instead, use one of the valid forms.</p>

```js
var obj = {
  x: 1,
  foo: function(){
  ...
  }
};
delete obj['x'];
delete obj.foo;
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/delete"><code>delete</code> operator</a>
  </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Global_object">Global object</a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/globalThis"><code>globalThis</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Modules">ECMAScript modules</a> </li>
  <li> Node.js Documentation - <a href="https://nodejs.org/api/modules.html">CommonJS modules</a> </li>
</ul>