<h2>Why is this an issue?</h2>
<p>In JavaScript, the <code>in</code> operator is primarily used to check if a property exists in an object or if an index exists in an array.
However, it is not suitable for use with primitive types such as numbers, strings, or booleans because they are not objects and do not have
properties.</p>
<p>If the right operand is of primitive type, the <code>in</code> operator raises a <code>TypeError</code>.</p>

```js
let x = "Foo";
"length" in x; // Noncompliant: TypeError
0 in x;        // Noncompliant: TypeError
"foobar" in x; // Noncompliant: TypeError
```
<p>You should use the object equivalents of numbers, strings, or booleans if you really want to check property existence with the <code>in</code>
operator.</p>

```js
let x = new String("Foo");
"length" in x;    // true
0 in x;           // true
"foobar" in x;    // false
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/in">in operator</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Primitive">Primitive</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/Number">Number()
  constructor</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/String">String()
  constructor</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean/Boolean">Boolean()
  constructor</a> </li>
</ul>