<h2>Why is this an issue?</h2>
<p>React JSX differs from the HTML standard in the way it handles newline characters and surrounding whitespace. HTML collapses multiple whitespace
characters (including newlines) into a single whitespace, but JSX removes such sequences completely, leaving no space between inline elements
separated by the line break. This difference in behavior can be confusing and may result in unintended layout, for example, missing whitespace between
the link content and the surrounding text.</p>
<p>To avoid such issues, you should never rely on newline characters in JSX, and explicitly specify whether you want whitespace between inline
elements separated by a line break.</p>

```js
<div>{/* Noncompliant: ambiguous spacing */}
  Here is some
  <a>space</a>
</div>

<div>{/* Noncompliant: ambiguous spacing */}
  <a>No space</a>
  between these
</div>
```
<p>To fix the issue, either insert an explicit JSX space as a string expression <code>{' '}</code>, or insert an empty comment expression <code>{/*
*/}</code> to indicate that the two parts will be joined together with no space between them.</p>

```js
<div>
  Here is some{' '}
  <a>space</a>
</div>

<div>
  <a>No space</a>{/*
  */}between these
</div>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> React Documentation - <a href="https://react.dev/learn#writing-markup-with-jsx">Writing markup with JSX</a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/API/Document_Object_Model/Whitespace#spaces_in_between_inline_and_inline-block_elements">Spaces
  in between inline and inline-block elements</a> </li>
</ul>