<h2>Why is this an issue?</h2>
<p>ARIA (Accessible Rich Internet Applications) roles are used to make web content and web applications more accessible to people with disabilities.
However, you should not use an ARIA role on a generic element (like <code>span</code> or <code>div</code>) if there is a semantic HTML tag with
similar functionality, just use that tag instead.</p>
<p>For example, instead of using a div element with a button role (<code>&lt;div role="button"&gt;Click me&lt;/div&gt;</code>), you should just use a
button element (<code>&lt;button&gt;Click me&lt;/button&gt;</code>).</p>
<p>Semantic HTML tags are generally preferred over ARIA roles for accessibility due to their built-in functionality, universal support by browsers and
assistive technologies, simplicity, and maintainability. They come with inherent behaviors and keyboard interactions, reducing the need for additional
JavaScript. Semantic HTML also enhances SEO by helping search engines better understand the content and structure of web pages. While ARIA roles are
useful, they should be considered a last resort when no suitable HTML element can provide the required behavior or semantics.</p>

```js
<div role="button" onClick={handleClick} /* Noncompliant */>Click me</div>
```
<p>Replace the ARIA role with an appropriate HTML tag.</p>

```js
<button onClick={handleClick}>Click me</button>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Techniques">Using ARIA: Roles, states, and
  properties</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles">ARIA roles (Reference)</a> </li>
</ul>
<h3>Standards</h3>
<ul>
  <li> W3C - <a href="https://www.w3.org/TR/wai-aria-1.2/">Accessible Rich Internet Applications (WAI-ARIA) 1.2</a> </li>
</ul>