<h2>Why is this an issue?</h2>
<p>ARIA (Accessible Rich Internet Applications) attributes are used to enhance the accessibility of web content and web applications. These attributes
provide additional information about an element’s role, state, properties, and values to assistive technologies like screen readers.</p>
<p>In HTML, certain elements have default roles. Default roles, also known as implicit roles, are roles that are inherently associated with certain
HTML elements. These roles provide information about what an element does or the type of content it contains, which is especially useful for assistive
technologies like screen readers.</p>
<p>For example, a <code>&lt;button&gt;</code> element has a default role of <code>button</code>. If you explicitly define the role of a
<code>&lt;button&gt;</code> element as <code>button</code>, it’s considered redundant because it’s the default role of that element.</p>

```js
<button role="button" onClick={handleClick}>OK</button>
```
<p>Remove ARIA role attributes when they are redundant.</p>

```js
<button onClick={handleClick}>OK</button>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Techniques">Using ARIA: Roles, states, and
  properties</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles">ARIA roles (Reference)</a> </li>
</ul>
<h3>Standards</h3>
<ul>
  <li> W3C - <a href="https://www.w3.org/TR/wai-aria-1.2/">Accessible Rich Internet Applications (WAI-ARIA) 1.2</a> </li>
</ul>