<h2>Why is this an issue?</h2>
<p>An iframe, or inline frame, is an HTML document embedded inside another HTML document on a website. The iframe HTML element is often used to insert
content from another source, such as an advertisement, into a web page.</p>
<p>In the context of web accessibility, <code>&lt;iframe&gt;</code>'s should have a <code>title</code> attribute. This is because screen readers for
the visually impaired use this title to help users understand the content of the iframe.</p>
<p>Without a title, it can be difficult for these users to understand the context or purpose of the iframe’s content.</p>
<h2>How to fix it</h2>
<p>To fix missing iframe titles, you simply need to add a <code>title</code> attribute to your <code>&lt;iframe&gt;</code> element. The value of this
attribute should be a brief description of the iframe’s content.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```js
function iframe() {
    return (
        <iframe src="https://openweathermap.org"></iframe> // Noncompliant
    );
}
```
<h4>Compliant solution</h4>

```js
function iframe() {
    return (
        <iframe src="https://openweathermap.org" title="Weather forecasts, nowcasts and history"></iframe>
    );
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe">iframe element</a> </li>
  <li> WCAG - <a href="https://www.w3.org/WAI/WCAG21/Understanding/bypass-blocks">Bypass Blocks</a> </li>
  <li> WCAG - <a href="https://www.w3.org/WAI/WCAG21/Understanding/name-role-value">Name, Role, Value</a> </li>
</ul>