<h2>Why is this an issue?</h2>
<p>Two functions having the same implementation are suspicious. It might be that something else was intended. Or the duplication is intentional, which
becomes a maintenance burden.</p>

```kotlin
class MyClass {
  fun calculateCode(): String {
    doTheThing()
    doOtherThing()
    return "done"
  }

  fun getStatus(): String {  // Noncompliant: duplicates calculateCode
    doTheThing()
    doOtherThing()
    return "done"
  }
}
```
<p>If the identical logic is intentional, the code should be refactored to avoid duplication. For example, by having both functions call the same
function or by having one implementation invoke the other.</p>

```kotlin
class MyClass {
  fun calculateCode(): String {
    doTheThing()
    doOtherThing()
    return "done"
  }

  fun getStatus(): String = calculateCode() // Intent is clear
}
```
<h3>Exceptions</h3>
<p>Methods with fewer than 2 statements are ignored.</p>